//Note: Details of scilab software version and OS version used:
//Tested on OS: Windows 7 SP1, 64 bit and Windows XP SP3, 32 bit
//Scilab version: 5.4.1 (Tested on both 32 bit and 64 bit versions)
//Program Title: Hamming Codes (7,4)

clc;
clear;

k = 4; //Information message matrix length
n = 7; //Coded word length

P = [1 1 0;0 1 1 ;1 1 1;1 0 1]//Parity Matrix
disp(P,'Parity Matrix P')

G = [P eye(k,k)]//Generator Matrix to create code word in P1P2P3D1D2D3D4 format
G(:,[3 4])=G(:,[4 3])//Swap colomn 3 and 4 of G to create code word in P1P2D1P3D2D3D4 format
disp(G,'Generator Matrix G')

H=[eye(n-k,n-k);P]'//Parity Check Matrix
H(:,[3 4])=H(:,[4 3])//Swap colomn 3 and 4 of H to satisfy GH'=0
disp(H,'Parity Check Matrix H')

//disp(modulo(G*H',2),'GH')//Check if the condition GH'=0 satisfy (for testing)

//M = [1 1 0 1]//Information Message Matrix for testing

//Generate random message
//All_M = All 16 posibilities for Information Message Matrix
All_M = [0 0 0 0;0 0 0 1;0 0 1 0;0 0 1 1;
0 1 0 0;0 1 0 1;0 1 1 0;0 1 1 1;
1 0 0 0;1 0 0 1;1 0 1 0;1 0 1 1;
1 1 0 0;1 1 0 1;1 1 1 0;1 1 1 1]
RandMessage=modulo(round(16*rand()),16)+1//Get random number between 1 to 16
M=All_M(RandMessage,:)//Select a random row from 1 to 16 as Information Message

disp(M,'Information Message M')

C = M*G;//Generate code word
C = modulo(C,2);//Convert generated code into binary
disp(C,'Code word of (7,4) Hamming code M*G')

R=C//Create recieved code word

//Generate error at random bit position

ErrPos=modulo(round(8*rand()),8)//Get random number between 0 to 7

if ErrPos==0 then
    //Do nothing, as '0' means no error
else
    if R(ErrPos)==0 then
        R(ErrPos)=1//Invert bit at Erroneous Bit Position
    else
        R(ErrPos)=0//Invert bit at Erroneous Bit Position
    end
end

disp(R,'Recieved Code word R')

//Error Correction

S=R*H'//Find Syndrome Matrix
S = modulo(S,2);//Convert Syndrome Matrix into binary
disp(S,'Syndrome Matrix R*H(transpose)')

if S==[0 0 0]  then //[0 0 0] indicates no error
    disp(R,'Recieved Code without error')
    disp([R(3) R(5:7)],'Recieved Information Message')//Extract and display  Message from code word
else 
    //Find erroneous bit position
    //Here we find colomn within H matrix with pattern simmilar to Syndrome Matrix
    //The position number of that colomn is equivalent to erroneous bit position
    
    ErrPos=1//Initiallize erroneous bit position
    d=[H(:,ErrPos)]'//Transpose of first coloumn of H matrix 
                    //(Transpose is used to convert colomn to row as syndrome is in row format)
               
        while ((d(1)<>S(1))|(d(2)<>S(2))|(d(3)<>S(3))) do //Check element wise inequallity for any element (OR condition)
            ErrPos=ErrPos+1//Increament erroneous bit position (Point to next colomn)
            d=[H(:,ErrPos)]'//Transpose of next coloumn of H matrix
        end
    
        disp(ErrPos,'Erroneous Bit Position')
    
        //Error correction
        if R(ErrPos)==0 then
                R(ErrPos)=1//Invert bit at Erroneous Bit Position
                disp(R,'Recieved Code with error corrected')
                disp([R(3) R(5:7)],'Recieved Information Message')//Extract and display  Message from code word
        else
            R(ErrPos)=0//Invert bit at Erroneous Bit Position
            disp(R,'Recieved Code with error corrected')
            disp([R(3) R(5:7)],'Recieved Information Message')//Extract and display Message from code word
        end
end
